/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;

public class MessageArea
extends Panel {
    protected static final int thickness = 2;
    protected String message;
    protected int height = 24;

    public MessageArea() {
        this.setLayout(new BorderLayout());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        return new Dimension(dimension.width, this.height);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Point point = new Point(1, 1);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.lightGray);
        int n = 0;
        while (n < 2) {
            graphics.draw3DRect(point.x, point.y, dimension.width - 2, dimension.height - 2, false);
            ++point.x;
            ++point.y;
            dimension.width -= 2;
            dimension.height -= 2;
            ++n;
        }
        if (this.message != null) {
            graphics.setColor(Color.black);
            this.height = fontMetrics.getHeight() + 6 > this.height ? fontMetrics.getHeight() + 6 : this.height;
            int n2 = this.getSize().height / 2 + fontMetrics.getAscent() / 2 - 1;
            graphics.drawString(this.message, 10, n2);
        }
    }

    public void displayMsg(String string) {
        Graphics graphics = this.getGraphics();
        Dimension dimension = this.getSize();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.message != null) {
                int n = fontMetrics.stringWidth(this.message);
                graphics.setColor(this.getBackground());
                graphics.fillRect(10, 3, n, dimension.height - 6);
            }
            this.message = string;
            if (this.message != null) {
                graphics.setColor(this.getForeground());
                this.height = fontMetrics.getHeight() + 6 > this.height ? fontMetrics.getHeight() + 6 : this.height;
                int n = dimension.height / 2 + fontMetrics.getAscent() / 2 - 1;
                graphics.drawString(this.message, 10, n);
            }
        }
    }
}

